package com.smartpos.emvsample.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.smartpos.accessoryagent.aidl.IRemoteAccessoryApi;
import com.smartpos.emvsample.activity.Sale;
import com.smartpos.emvsample.constant.EMVConstant;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;

public class Receiver extends BroadcastReceiver implements EMVConstant {
    private final String TAG = "Receiver";

    private IRemoteAccessoryApi remoteServe;

    @Override
    public void onReceive(Context context, Intent intent) {
        if(D22_PAY_REQUEST_ACTION.equals(intent.getAction())){
            Log.i(TAG, D22_PAY_REQUEST_ACTION + " in----->"+new Date().toString());

            String sJson = intent.getExtras().getString("AidlData");
            Log.i(TAG,"D22 AidlData:" + sJson);

            try {
                //Need to unpack the Json and call different transactions with different transType(sale/Void/Refund/....)
                //Now this sample always call Sale transaction

                JSONObject json = new JSONObject(sJson);
                long transAmount =json.optLong("TransAmount",0);
                Bundle bundle = new Bundle();
                bundle.putBoolean(TRANS_EXTERNAL,true);
                bundle.putLong(TRANS_AMOUNT_FLAG,transAmount);

                Intent intentMainActivity = new Intent(context, Sale.class);
                intentMainActivity.putExtras(bundle);
                intentMainActivity.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intentMainActivity);

            } catch (JSONException e) {
                e.printStackTrace();
            }

        }
    }
}
