package com.smartpos.emvsample.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class CAPKService {
	private SQLiteDatabase db = null;
	private Cursor queryCursor = null;

	public CAPKService(SQLiteDatabase db)
	{
		this.db = db;
	}
	
	public void save(CAPKTable capk)
	{
		db.execSQL("insert into " + DatabaseOpenHelper.TABLE_CAPK + 
               "(rid,capki,hashIndex,arithIndex,modul," +
               "exponent,checkSum,expiry) " +
               "values(?,?,?,?,?, ?,?,?)", 
               new Object[]{capk.getRID(),
				            capk.getCapki(),
							capk.getHashIndex(),
							capk.getArithIndex(),
							capk.getModul(),
	                                                            
							capk.getExponent(),
							capk.getChecksum(),
							capk.getExpiry() });
	}
	
	public void update(CAPKTable capk)
	{
		db.execSQL("update " + DatabaseOpenHelper.TABLE_CAPK + 
               " set hashIndex=?,arithIndex=?,modul=?,exponent=?,checkSum=?,expiry=? where rid=? and capki=?", 
               new Object[]{capk.getHashIndex(),
							capk.getArithIndex(),
							capk.getModul(),
	                        capk.getExponent(),
							capk.getChecksum(),
							capk.getExpiry(),
							capk.getRID(),
				            capk.getCapki()    });
	}
	
	public void delete(String rid, String capki)
	{
		db.execSQL("delete from " + DatabaseOpenHelper.TABLE_CAPK + " where rid=? and capki=?", new String[]{rid, capki});
	}
	
	public CAPKTable find(String rid, byte capki)
	{
		CAPKTable capk = null;
		queryCursor = db.rawQuery("select _id,rid,capki,hashIndex,arithIndex,modul," +
                                     "exponent,checkSum,expiry from "
				                     + DatabaseOpenHelper.TABLE_CAPK + " where rid=? and capki=?", new String[]{String.valueOf(rid), String.valueOf(capki)});
        if(queryCursor == null || queryCursor.getCount() == 0)
        {
        	if(queryCursor != null)
        		queryCursor.close();
        	return null;
        }
		if(queryCursor.moveToNext())
        {
        	capk = new CAPKTable();
        	getCAPKFromCursor(capk, false);
        }
        queryCursor.close();
        return capk;
	}
	
	public long getCAPKCount()
	{
		queryCursor = db.rawQuery("select count(*) from " + DatabaseOpenHelper.TABLE_CAPK, null);
		queryCursor.moveToFirst();
		long count = queryCursor.getLong(0);
		queryCursor.close();
		return count;
	}
	
	private void getCAPKFromCursor(CAPKTable capk, boolean closeFlag )
	{
		capk.setId(queryCursor.getInt(0));
		capk.setRID(queryCursor.getString(1));
		capk.setCapki(queryCursor.getString(2));
		capk.setHashIndex((byte)queryCursor.getShort(3));
		capk.setArithIndex((byte)queryCursor.getShort(4));
		capk.setModul(queryCursor.getString(5));
		capk.setExponent(queryCursor.getString(6));
		capk.setChecksum(queryCursor.getString(7));
		capk.setExpiry(queryCursor.getString(8));
    	
        if(closeFlag)
        {
        	queryCursor.close();
        }
	}
	
	public CAPKTable[] query()
	{
		queryCursor = db.rawQuery("select _id,rid,capki,hashIndex,arithIndex,modul," +
	               "exponent,checkSum,expiry from " + DatabaseOpenHelper.TABLE_CAPK, null);
        if(queryCursor == null || queryCursor.getCount() == 0)
        {
        	if(queryCursor != null)
        		queryCursor.close();
        	return null;
        }
		int i = 0;
		CAPKTable[] capks = new CAPKTable[queryCursor.getCount()];
		for(queryCursor.moveToFirst();!queryCursor.isAfterLast() && i < capks.length; queryCursor.moveToNext(),i++)
		{
			capks[i] = new CAPKTable();
			getCAPKFromCursor(capks[i], false);
		}
		queryCursor.close();
		return capks;
	}
	
    public void createDefaultCAPK()
    {
		CAPKTable capkTable = new CAPKTable();
		capkTable.setArithIndex((byte)0x01);
		capkTable.setHashIndex((byte)0x01);
		// Released CAPK
		// VISA
		//03 A000000003 08
		capkTable.setRID("A000000003");
		capkTable.setExpiry("20241231");
		capkTable.setCapki("08");
		capkTable.setExponent("03");
		capkTable.setChecksum("20D213126955DE205ADC2FD2822BD22DE21CF9A8");
		capkTable.setModul("D9FD6ED75D51D0E30664BD157023EAA1FFA871E4DA65672B863D255E81E137A51DE4F72BCC9E44ACE12127F87E263D3AF9DD9CF35CA4A7B01E907000BA85D24954C2FCA3074825DDD4C0C8F186CB020F683E02F2DEAD3969133F06F7845166ACEB57CA0FC2603445469811D293BFEFBAFAB57631B3DD91E796BF850A25012F1AE38F05AA5C4D6D03B1DC2E568612785938BBC9B3CD3A910C1DA55A5A9218ACE0F7A21287752682F15832A678D6E1ED0B");
		save(capkTable);
		//04 A000000003 09
		capkTable.setRID("A000000003");
		capkTable.setExpiry("20271231");
		capkTable.setCapki("09");
		capkTable.setExponent("03");
		capkTable.setChecksum("1FF80A40173F52D7D27E0F26A146A1C8CCB29046");
		capkTable.setModul("9D912248DE0A4E39C1A7DDE3F6D2588992C1A4095AFBD1824D1BA74847F2BC4926D2EFD904B4B54954CD189A54C5D1179654F8F9B0D2AB5F0357EB642FEDA95D3912C6576945FAB897E7062CAA44A4AA06B8FE6E3DBA18AF6AE3738E30429EE9BE03427C9D64F695FA8CAB4BFE376853EA34AD1D76BFCAD15908C077FFE6DC5521ECEF5D278A96E26F57359FFAEDA19434B937F1AD999DC5C41EB11935B44C18100E857F431A4A5A6BB65114F174C2D7B59FDF237D6BB1DD0916E644D709DED56481477C75D95CDD68254615F7740EC07F330AC5D67BCD75BF23D28A140826C026DBDE971A37CD3EF9B8DF644AC385010501EFC6509D7A41");
		save(capkTable);
		//MasterCard
		//05 A000000004 03 - Expired

		//06 A000000004 04 - Expired
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20171231");
		capkTable.setCapki("04");
		capkTable.setExponent("03");
		capkTable.setChecksum("381A035DA58B482EE2AF75F4C3F2CA469BA4AA6C");
		capkTable.setModul("A6DA428387A502D7DDFB7A74D3F412BE762627197B25435B7A81716A700157DDD06F7CC99D6CA28C2470527E2C03616B9C59217357C2674F583B3BA5C7DCF2838692D023E3562420B4615C439CA97C44DC9A249CFCE7B3BFB22F68228C3AF13329AA4A613CF8DD853502373D62E49AB256D2BC17120E54AEDCED6D96A4287ACC5C04677D4A5A320DB8BEE2F775E5FEC5");
		save(capkTable);
		//07 A000000004 05
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20231231");
		capkTable.setCapki("05");
		capkTable.setExponent("03");
		capkTable.setChecksum("EBFA0D5D06D8CE702DA3EAE890701D45E274C845");
		capkTable.setModul("B8048ABC30C90D976336543E3FD7091C8FE4800DF820ED55E7E94813ED00555B573FECA3D84AF6131A651D66CFF4284FB13B635EDD0EE40176D8BF04B7FD1C7BACF9AC7327DFAA8AA72D10DB3B8E70B2DDD811CB4196525EA386ACC33C0D9D4575916469C4E4F53E8E1C912CC618CB22DDE7C3568E90022E6BBA770202E4522A2DD623D180E215BD1D1507FE3DC90CA310D27B3EFCCD8F83DE3052CAD1E48938C68D095AAC91B5F37E28BB49EC7ED597");
		save(capkTable);
		//08 A000000004 06
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20231231");
		capkTable.setCapki("06");
		capkTable.setExponent("03");
		capkTable.setChecksum("F910A1504D5FFB793D94F3B500765E1ABCAD72D9");
		capkTable.setModul("CB26FC830B43785B2BCE37C81ED334622F9622F4C89AAE641046B2353433883F307FB7C974162DA72F7A4EC75D9D657336865B8D3023D3D645667625C9A07A6B7A137CF0C64198AE38FC238006FB2603F41F4F3BB9DA1347270F2F5D8C606E420958C5F7D50A71DE30142F70DE468889B5E3A08695B938A50FC980393A9CBCE44AD2D64F630BB33AD3F5F5FD495D31F37818C1D94071342E07F1BEC2194F6035BA5DED3936500EB82DFDA6E8AFB655B1EF3D0D7EBF86B66DD9F29F6B1D324FE8B26CE38AB2013DD13F611E7A594D675C4432350EA244CC34F3873CBA06592987A1D7E852ADC22EF5A2EE28132031E48F74037E3B34AB747F");
		save(capkTable);
		//JCB
		//09 A000000065 09 - expired

		//10 A000000065 10 - expired
		capkTable.setRID("A000000065");
		capkTable.setExpiry("20171231");
		capkTable.setCapki("10");
		capkTable.setExponent("03");
		capkTable.setChecksum("C75E5210CBE6E8F0594A0F1911B07418CADB5BAB");
		capkTable.setModul("99B63464EE0B4957E4FD23BF923D12B61469B8FFF8814346B2ED6A780F8988EA9CF0433BC1E655F05EFA66D0C98098F25B659D7A25B8478A36E489760D071F54CDF7416948ED733D816349DA2AADDA227EE45936203CBF628CD033AABA5E5A6E4AE37FBACB4611B4113ED427529C636F6C3304F8ABDD6D9AD660516AE87F7F2DDF1D2FA44C164727E56BBC9BA23C0285");
		save(capkTable);
		//11 A000000065 12
		capkTable.setRID("A000000065");
		capkTable.setExpiry("20241231");
		capkTable.setCapki("12");
		capkTable.setExponent("03");
		capkTable.setChecksum("874B379B7F607DC1CAF87A19E400B6A9E25163E8");
		capkTable.setModul("ADF05CD4C5B490B087C3467B0F3043750438848461288BFEFD6198DD576DC3AD7A7CFA07DBA128C247A8EAB30DC3A30B02FCD7F1C8167965463626FEFF8AB1AA61A4B9AEF09EE12B009842A1ABA01ADB4A2B170668781EC92B60F605FD12B2B2A6F1FE734BE510F60DC5D189E401451B62B4E06851EC20EBFF4522AACC2E9CDC89BC5D8CDE5D633CFD77220FF6BBD4A9B441473CC3C6FEFC8D13E57C3DE97E1269FA19F655215B23563ED1D1860D8681");
		save(capkTable);
		//12 A000000065 14
		capkTable.setRID("A000000065");
		capkTable.setExpiry("20251231");
		capkTable.setCapki("14");
		capkTable.setExponent("03");
		capkTable.setChecksum("C0D15F6CD957E491DB56DCDD1CA87A03EBE06B7B");
		capkTable.setModul("AEED55B9EE00E1ECEB045F61D2DA9A66AB637B43FB5CDBDB22A2FBB25BE061E937E38244EE5132F530144A3F268907D8FD648863F5A96FED7E42089E93457ADC0E1BC89C58A0DB72675FBC47FEE9FF33C16ADE6D341936B06B6A6F5EF6F66A4EDD981DF75DA8399C3053F430ECA342437C23AF423A211AC9F58EAF09B0F837DE9D86C7109DB1646561AA5AF0289AF5514AC64BC2D9D36A179BB8A7971E2BFA03A9E4B847FD3D63524D43A0E8003547B94A8A75E519DF3177D0A60BC0B4BAB1EA59A2CBB4D2D62354E926E9C7D3BE4181E81BA60F8285A896D17DA8C3242481B6C405769A39D547C74ED9FF95A70A796046B5EFF36682DC29");
		save(capkTable);
		//CUP
		//13 A000000333 01 - Expired

		//14 A000000333 02
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20211231");
		capkTable.setCapki("02");
		capkTable.setExponent("03");
		capkTable.setChecksum("03BB335A8549A03B87AB089D006F60852E4B8060");
		capkTable.setModul("A3767ABD1B6AA69D7F3FBF28C092DE9ED1E658BA5F0909AF7A1CCD907373B7210FDEB16287BA8E78E1529F443976FD27F991EC67D95E5F4E96B127CAB2396A94D6E45CDA44CA4C4867570D6B07542F8D4BF9FF97975DB9891515E66F525D2B3CBEB6D662BFB6C3F338E93B02142BFC44173A3764C56AADD202075B26DC2F9F7D7AE74BD7D00FD05EE430032663D27A57");
		save(capkTable);

		//15 A000000333 03
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20241231");
		capkTable.setCapki("03");
		capkTable.setExponent("03");
		capkTable.setChecksum("87F0CD7C0E86F38F89A66F8C47071A8B88586F26");
		capkTable.setModul("B0627DEE87864F9C18C13B9A1F025448BF13C58380C91F4CEBA9F9BCB214FF8414E9B59D6ABA10F941C7331768F47B2127907D857FA39AAF8CE02045DD01619D689EE731C551159BE7EB2D51A372FF56B556E5CB2FDE36E23073A44CA215D6C26CA68847B388E39520E0026E62294B557D6470440CA0AEFC9438C923AEC9B2098D6D3A1AF5E8B1DE36F4B53040109D89B77CAFAF70C26C601ABDF59EEC0FDC8A99089140CD2E817E335175B03B7AA33D");
		save(capkTable);

		//16 A000000333 04
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20271231");
		capkTable.setCapki("04");
		capkTable.setExponent("03");
		capkTable.setChecksum("F527081CF371DD7E1FD4FA414A665036E0F5E6E5");
		capkTable.setModul("BC853E6B5365E89E7EE9317C94B02D0ABB0DBD91C05A224A2554AA29ED9FCB9D86EB9CCBB322A57811F86188AAC7351C72BD9EF196C5A01ACEF7A4EB0D2AD63D9E6AC2E7836547CB1595C68BCBAFD0F6728760F3A7CA7B97301B7E0220184EFC4F653008D93CE098C0D93B45201096D1ADFF4CF1F9FC02AF759DA27CD6DFD6D789B099F16F378B6100334E63F3D35F3251A5EC78693731F5233519CDB380F5AB8C0F02728E91D469ABD0EAE0D93B1CC66CE127B29C7D77441A49D09FCA5D6D9762FC74C31BB506C8BAE3C79AD6C2578775B95956B5370D1D0519E37906B384736233251E8F09AD79DFBE2C6ABFADAC8E4D8624318C27DAF1");
		save(capkTable);

		// Test CAPK
		// VISA
		//01 A000000003 95
		capkTable.setRID("A000000003");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("95");
		capkTable.setExponent("03");
		capkTable.setChecksum("EE1511CEC71020A9B90443B37B1D5F6E703030F6");
		capkTable.setModul("BE9E1FA5E9A803852999C4AB432DB28600DCD9DAB76DFAAA47355A0FE37B1508AC6BF38860D3C6C2E5B12A3CAAF2A7005A7241EBAA7771112C74CF9A0634652FBCA0E5980C54A64761EA101A114E0F0B5572ADD57D010B7C9C887E104CA4EE1272DA66D997B9A90B5A6D624AB6C57E73C8F919000EB5F684898EF8C3DBEFB330C62660BED88EA78E909AFF05F6DA627B");
		save(capkTable);

		//02 A000000003 92
		capkTable.setRID("A000000003");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("92");
		capkTable.setExponent("03");
		capkTable.setChecksum("429C954A3859CEF91295F663C963E582ED6EB253");
		capkTable.setModul("996AF56F569187D09293C14810450ED8EE3357397B18A2458EFAA92DA3B6DF6514EC060195318FD43BE9B8F0CC669E3F844057CBDDF8BDA191BB64473BC8DC9A730DB8F6B4EDE3924186FFD9B8C7735789C23A36BA0B8AF65372EB57EA5D89E7D14E9C7B6B557460F10885DA16AC923F15AF3758F0F03EBD3C5C2C949CBA306DB44E6A2C076C5F67E281D7EF56785DC4D75945E491F01918800A9E2DC66F60080566CE0DAF8D17EAD46AD8E30A247C9F");
		save(capkTable);

		//03 A000000003 94
		capkTable.setRID("A000000003");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("94");
		capkTable.setExponent("03");
		capkTable.setChecksum("C4A3C43CCF87327D136B804160E47D43B60E6E0F");
		capkTable.setModul("ACD2B12302EE644F3F835ABD1FC7A6F62CCE48FFEC622AA8EF062BEF6FB8BA8BC68BBF6AB5870EED579BC3973E121303D34841A796D6DCBC41DBF9E52C4609795C0CCF7EE86FA1D5CB041071ED2C51D2202F63F1156C58A92D38BC60BDF424E1776E2BC9648078A03B36FB554375FC53D57C73F5160EA59F3AFC5398EC7B67758D65C9BFF7828B6B82D4BE124A416AB7301914311EA462C19F771F31B3B57336000DFF732D3B83DE07052D730354D297BEC72871DCCF0E193F171ABA27EE464C6A97690943D59BDABB2A27EB71CEEBDAFA1176046478FD62FEC452D5CA393296530AA3F41927ADFE434A2DF2AE3054F8840657A26E0FC617");
		save(capkTable);

		//04 A000000003 57
		capkTable.setRID("A000000003");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("57");
		capkTable.setExponent("010001");
		capkTable.setChecksum("251A5F5DE61CF28B5C6E2B5807C0644A01D46FF5");
		capkTable.setModul("942B7F2BA5EA307312B63DF77C5243618ACC2002BD7ECB74D821FE7BDC78BF28F49F74190AD9B23B9713B140FFEC1FB429D93F56BDC7ADE4AC075D75532C1E590B21874C7952F29B8C0F0C1CE3AEEDC8DA25343123E71DCF86C6998E15F756E3");
		save(capkTable);

		// MasterCard
		//01 A000000004 EF
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("EF");
		capkTable.setExponent("03");
		capkTable.setChecksum("21766EBB0EE122AFB65D7845B73DB46BAB65427A");
		capkTable.setModul("A191CB87473F29349B5D60A88B3EAEE0973AA6F1A082F358D849FDDFF9C091F899EDA9792CAF09EF28F5D22404B88A2293EEBBC1949C43BEA4D60CFD879A1539544E09E0F09F60F065B2BF2A13ECC705F3D468B9D33AE77AD9D3F19CA40F23DCF5EB7C04DC8F69EBA565B1EBCB4686CD274785530FF6F6E9EE43AA43FDB02CE00DAEC15C7B8FD6A9B394BABA419D3F6DC85E16569BE8E76989688EFEA2DF22FF7D35C043338DEAA982A02B866DE5328519EBBCD6F03CDD686673847F84DB651AB86C28CF1462562C577B853564A290C8556D818531268D25CC98A4CC6A0BDFFFDA2DCCA3A94C998559E307FDDF915006D9A987B07DDAEB3B");
		save(capkTable);

		//02 A000000004 F1
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F1");
		capkTable.setExponent("03");
		capkTable.setChecksum("D8E68DA167AB5A85D8C3D55ECB9B0517A1A5B4BB");
		capkTable.setModul("A0DCF4BDE19C3546B4B6F0414D174DDE294AABBB828C5A834D73AAE27C99B0B053A90278007239B6459FF0BBCD7B4B9C6C50AC02CE91368DA1BD21AAEADBC65347337D89B68F5C99A09D05BE02DD1F8C5BA20E2F13FB2A27C41D3F85CAD5CF6668E75851EC66EDBF98851FD4E42C44C1D59F5984703B27D5B9F21B8FA0D93279FBBF69E090642909C9EA27F898959541AA6757F5F624104F6E1D3A9532F2A6E51515AEAD1B43B3D7835088A2FAFA7BE7");
		save(capkTable);

		//03 A000000004 F3
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F3");
		capkTable.setExponent("03");
		capkTable.setChecksum("A69AC7603DAF566E972DEDC2CB433E07E8B01A9A");
		capkTable.setModul("98F0C770F23864C2E766DF02D1E833DFF4FFE92D696E1642F0A88C5694C6479D16DB1537BFE29E4FDC6E6E8AFD1B0EB7EA0124723C333179BF19E93F10658B2F776E829E87DAEDA9C94A8B3382199A350C077977C97AFF08FD11310AC950A72C3CA5002EF513FCCC286E646E3C5387535D509514B3B326E1234F9CB48C36DDD44B416D23654034A66F403BA511C5EFA3");
		save(capkTable);

		//04 A000000004 F5
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F5");
		capkTable.setExponent("010001");
		capkTable.setChecksum("C2239804C8098170BE52D6D5D4159E81CE8466BF");
		capkTable.setModul("A6E6FB72179506F860CCCA8C27F99CECD94C7D4F3191D303BBEE37481C7AA15F233BA755E9E4376345A9A67E7994BDC1C680BB3522D8C93EB0CCC91AD31AD450DA30D337662D19AC03E2B4EF5F6EC18282D491E19767D7B24542DFDEFF6F62185503532069BBB369E3BB9FB19AC6F1C30B97D249EEE764E0BAC97F25C873D973953E5153A42064BBFABFD06A4BB486860BF6637406C9FC36813A4A75F75C31CCA9F69F8DE59ADECEF6BDE7E07800FCBE035D3176AF8473E23E9AA3DFEE221196D1148302677C720CFE2544A03DB553E7F1B8427BA1CC72B0F29B12DFEF4C081D076D353E71880AADFF386352AF0AB7B28ED49E1E672D11F9");
		save(capkTable);

		//05 A000000004 F6
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F6");
		capkTable.setExponent("03");
		capkTable.setChecksum("502909ED545E3C8DBD00EA582D0617FEE9F6F684");
		capkTable.setModul("A25A6BD783A5EF6B8FB6F83055C260F5F99EA16678F3B9053E0F6498E82C3F5D1E8C38F13588017E2B12B3D8FF6F50167F46442910729E9E4D1B3739E5067C0AC7A1F4487E35F675BC16E233315165CB142BFDB25E301A632A54A3371EBAB6572DEEBAF370F337F057EE73B4AE46D1A8BC4DA853EC3CC12C8CBC2DA18322D68530C70B22BDAC351DD36068AE321E11ABF264F4D3569BB71214545005558DE26083C735DB776368172FE8C2F5C85E8B5B890CC682911D2DE71FA626B8817FCCC08922B703869F3BAEAC1459D77CD85376BC36182F4238314D6C4212FBDD7F23D3");
		save(capkTable);

		//06 A000000004 F7
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F7");
		capkTable.setExponent("010001");
		capkTable.setChecksum("EEB0DD9B2477BEE3209A914CDBA94C1C4A9BDED9");
		capkTable.setModul("94EA62F6D58320E354C022ADDCF0559D8CF206CD92E869564905CE21D720F971B7AEA374830EBE1757115A85E088D41C6B77CF5EC821F30B1D890417BF2FA31E5908DED5FA677F8C7B184AD09028FDDE96B6A6109850AA800175EABCDBBB684A96C2EB6379DFEA08D32FE2331FE103233AD58DCDB1E6E077CB9F24EAEC5C25AF");
		save(capkTable);

		//07 A000000004 F8
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F8");
		capkTable.setExponent("03");
		capkTable.setChecksum("F06ECC6D2AAEBF259B7E755A38D9A9B24E2FF3DD");
		capkTable.setModul("A1F5E1C9BD8650BD43AB6EE56B891EF7459C0A24FA84F9127D1A6C79D4930F6DB1852E2510F18B61CD354DB83A356BD190B88AB8DF04284D02A4204A7B6CB7C5551977A9B36379CA3DE1A08E69F301C95CC1C20506959275F41723DD5D2925290579E5A95B0DF6323FC8E9273D6F849198C4996209166D9BFC973C361CC826E1");
		save(capkTable);

		//08 A000000004 F9
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("F9");
		capkTable.setExponent("03");
		capkTable.setChecksum("336712DCC28554809C6AA9B02358DE6F755164DB");
		capkTable.setModul("A99A6D3E071889ED9E3A0C391C69B0B804FC160B2B4BDD570C92DD5A0F45F53E8621F7C96C40224266735E1EE1B3C06238AE35046320FD8E81F8CEB3F8B4C97B940930A3AC5E790086DAD41A6A4F5117BA1CE2438A51AC053EB002AED866D2C458FD73359021A12029A0C043045C11664FE0219EC63C10BF2155BB2784609A106421D45163799738C1C30909BB6C6FE52BBB76397B9740CE064A613FF8411185F08842A423EAD20EDFFBFF1CD6C3FE0C9821479199C26D8572CC8AFFF087A9C3");
		save(capkTable);

		//09 A000000004 FA
		capkTable.setRID("A000000004");
		capkTable.setExpiry("20181231");
		capkTable.setCapki("FA");
		capkTable.setExponent("03");
		capkTable.setChecksum("5BED4068D96EA16D2D77E03D6036FC7A160EA99C");
		capkTable.setModul("A90FCD55AA2D5D9963E35ED0F440177699832F49C6BAB15CDAE5794BE93F934D4462D5D12762E48C38BA83D8445DEAA74195A301A102B2F114EADA0D180EE5E7A5C73E0C4E11F67A43DDAB5D55683B1474CC0627F44B8D3088A492FFAADAD4F42422D0E7013536C3C49AD3D0FAE96459B0F6B1B6056538A3D6D44640F94467B108867DEC40FAAECD740C00E2B7A8852D");
		save(capkTable);

		// CUP
		//04 A000000333 0A
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20271231");
		capkTable.setCapki("0A");
		capkTable.setExponent("03");
		capkTable.setChecksum("C88BE6B2417C4F941C9371EA35A377158767E4E3");
		capkTable.setModul("B2AB1B6E9AC55A75ADFD5BBC34490E53C4C3381F34E60E7FAC21CC2B26DD34462B64A6FAE2495ED1DD383B8138BEA100FF9B7A111817E7B9869A9742B19E5C9DAC56F8B8827F11B05A08ECCF9E8D5E85B0F7CFA644EFF3E9B796688F38E006DEB21E101C01028903A06023AC5AAB8635F8E307A53AC742BDCE6A283F585F48EF");
		save(capkTable);

		//05 A000000333 08
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20271231");
		capkTable.setCapki("08");
		capkTable.setExponent("03");
		capkTable.setChecksum("EE23B616C95C02652AD18860E48787C079E8E85A");
		capkTable.setModul("B61645EDFD5498FB246444037A0FA18C0F101EBD8EFA54573CE6E6A7FBF63ED21D66340852B0211CF5EEF6A1CD989F66AF21A8EB19DBD8DBC3706D135363A0D683D046304F5A836BC1BC632821AFE7A2F75DA3C50AC74C545A754562204137169663CFCC0B06E67E2109EBA41BC67FF20CC8AC80D7B6EE1A95465B3B2657533EA56D92D539E5064360EA4850FED2D1BF");
		save(capkTable);

		//06 A000000333 09
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20271231");
		capkTable.setCapki("09");
		capkTable.setExponent("03");
		capkTable.setChecksum("A075306EAB0045BAF72CDD33B3B678779DE1F527");
		capkTable.setModul("EB374DFC5A96B71D2863875EDA2EAFB96B1B439D3ECE0B1826A2672EEEFA7990286776F8BD989A15141A75C384DFC14FEF9243AAB32707659BE9E4797A247C2F0B6D99372F384AF62FE23BC54BCDC57A9ACD1D5585C303F201EF4E8B806AFB809DB1A3DB1CD112AC884F164A67B99C7D6E5A8A6DF1D3CAE6D7ED3D5BE725B2DE4ADE23FA679BF4EB15A93D8A6E29C7FFA1A70DE2E54F593D908A3BF9EBBD760BBFDC8DB8B54497E6C5BE0E4A4DAC29E5");
		save(capkTable);

		//07 A000000333 0B
		capkTable.setRID("A000000333");
		capkTable.setExpiry("20271231");
		capkTable.setCapki("0B");
		capkTable.setExponent("03");
		capkTable.setChecksum("BD331F9996A490B33C13441066A09AD3FEB5F66C");
		capkTable.setModul("CF9FDF46B356378E9AF311B0F981B21A1F22F250FB11F55C958709E3C7241918293483289EAE688A094C02C344E2999F315A72841F489E24B1BA0056CFAB3B479D0E826452375DCDBB67E97EC2AA66F4601D774FEAEF775ACCC621BFEB65FB0053FC5F392AA5E1D4C41A4DE9FFDFDF1327C4BB874F1F63A599EE3902FE95E729FD78D4234DC7E6CF1ABABAA3F6DB29B7F05D1D901D2E76A606A8CBFFFFECBD918FA2D278BDB43B0434F5D45134BE1C2781D157D501FF43E5F1C470967CD57CE53B64D82974C8275937C5D8502A1252A8A5D6088A259B694F98648D9AF2CB0EFD9D943C69F896D49FA39702162ACB5AF29B90BADE005BC157");
		save(capkTable);

//		//A000000228-01 18
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("18");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("9FE167D85CB9A9EF79FCA0B2CAB09C764850B93C");
//		capkTable.setModul("A523924AFD826DAD39BC4532CB121C19A702D2B0D3F29CE79E2CBD0F847BC112A5FF61EF0E3913A6DF63A3E8017FC2B19F0E61304889A88E406DAC0FF82A423052E5387EF6C073D2B8C6004D2D4077C5179A78902CE4A8F361A85C6F46D56A75F374AF7AAD0F8409098AC1F388517184001AA316D05C842907BF0D62F8A05E083DBC8FED48FF84108D1C411C5540604408C42066E6B2ED465BC0DCBBB06383EE88C1CF0A7F694317C8B3A8EF1019059B");
//		save(capkTable);
//
//		//A000000228-02 20
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("20");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("48AE1E709DBBBDC9CEED5B5FEEE233CD1248CA70");
//		capkTable.setModul("EBA2E3FBE75D51C519B7A498CFE53F51519B292C1BBE0C78C14FBE38E3717DE0C0ECC04605879EF617B97ED1E8E989FCD2C7DDF61EE09E96F7EADA7D9F553426D6D6A8BE4DCF943D6C8F3627265520F757BBA16FF68749F3D796A0AAACA0ED0929BE112BF7CAB87BED4D9B5DD9B7A0CAC7F9CA513A6BFC03B4C20EFDC03E2B58D76E2ABF466665CB9D64AA412FBBF85259C480DA2F0896AB28FBB26022EFAE74CCDB9C36749E8D29AE4069A1298A0B07A7F72DFF8E6F442A2393DFF7E4E1F06F");
//		save(capkTable);
//
//		//A000000228-03 21
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("21");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("64D1FDA19D5E0893A6A7A31987805BB9A3D19B8B");
//		capkTable.setModul("863B43586D710D2ECCF922644ACDD7015057A26BE7D6999A65D023DE94CD81A171E93C5BAB92C753767A4720C2ACFBF358387790CCD437806F9C1F19CF66FCF20BF42570FFE21ED742608F56C9CB0B4F277CF8EF3394C8BC595B314044197B7AAEAADBF1E44D763CDFE3DF368CBA6B09788F8EAEF9B47DEC02BEA131D58551430621D71AA5EEDE29FC1AC8CBE44CE92177E01EEBC080E94BEAD5FA0CAEF4B487");
//		save(capkTable);
//
//		//A000000228-04 22
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("22");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("E924B09D66B00B7811678092DF8F95D460F4CC47");
//		capkTable.setModul("9CC38384539AFFDB955ADF9FCF03A6A669B5F68D91DBE1562002D4617E75FF0BEF16731D8CAE5B6E690E00C0F106BD8EB127DAD03108D40576C95572B3C43E4A9641C11C4C5AED06643543CD02B6E3811FBC4F72956CA9D8641374CFB659263B8B22B5C5A3B624E99BF5CBFD34B99A069DA312B1F7C03CF8F4CFA91BB269DBD565073A9AFCB1DA7D839F13D43B57F924BB85E1BCCE28BE5A8EC03AA56FED231B13B920A3BA4227F53F927EC27F9DB20C32EB2AD8F9C0770EC97D930764E844C9");
//		save(capkTable);
//
//		//A000000228-05 23
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("23");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("6DE12BDA2B42F9950578C2C50A94A216636D6045");
//		capkTable.setModul("EEEACE9FD905E43DD1EC43F471570F9255379E43813267F0C6C0363977C607E8E169B834A5072977ADA9BDF4D0F50748F3D2DED1F863A9A510C4D67BC923EB53E77711BB079B32F2837F1381F141B27B9361E67DDB5AEF107F05231042A9D003DA49338476FBA2E8FFD8D48621C830A6BAB87751570BEAB77AA501846E8F9EDE25EAD306C45AA21CEEB506E5256AADB01AAA0A5C5773DB7A75DBFB5D1EA30C89BFCB4937C0B1B6EDADFF12F9808F1E9129A39AC6996C7D9E551BD1AF924320D965BC0726AD9F9CE430415F1FDF9AC37C3DC0454452D73F0E0B1CBC8214522F5F");
//		save(capkTable);
//
//		//A000000228-06 30
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("30");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("049A0871C0E8E136DD5F72629C8616483ED10B07");
//		capkTable.setModul("B6D73BF68564C88A1AEE8BA70A5F60CE495CA722E097DADEEBB83B28040B1BAD16DBC9AC3CD181BA89193638E600AF397D220F0339A8E792AA08C1878482ACC463B3B3A257AE8667CDBC1D6613CB9CBB612830FDA7F7BA689A148EFFF34476F6E0A70C819C10B3B6150909B58BF9403F5BB2E9790EE82C50C8D6FB267C726DC255AE97FABF5A357B2A0FBD1387168D83B25ECD912027B3868F072E025240CF780CC8E5839823727E5547FD1366A203F4F70FA82660B8401D4D2D06FD9A4036D14C53F6289D6FDC724E7D06F31ED93AC1B54083D9B9FCF09B135FDE9F4F6C1F0BA0142C3715E49015958C45315859DB12D942D75497FB51ED");
//		save(capkTable);
//
//		//A000000228-07 29
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("29");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("08374162F808F8DAD0CECB8FCD1AF5F64F213D6F");
//		capkTable.setModul("B6D73BF68564C88A1AEE8BA70A5F60CE495CA722E097DADEEBB83B28040B1BAD16DBC9AC3CD181BA89193638E600AF397D220F0339A8E792AA08C1878482ACC463B3B3A257AE8667CDBC1D6613CB9CBB612830FDA7F7BA689A148EFFF34476F6E0A70C819C10B3B6150909B58BF9403F5BB2E9790EE82C50C8D6FB267C726DC255AE97FABF5A357B2A0FBD1387168D83B25ECD912027B3868F072E025240CF780CC8E5839823727E5547FD1366A203F4F70FA82660B8401D4D2D06FD9A4036D14C53F6289D6FDC724E7D06F31ED93AC1B54083D9B9FCF09B135FDE9F4F6C1F0BA0142C3715E49015958C45315859DB12D942D75497FB51ED");
//		save(capkTable);
//
//		//A000000228-08 88
//		capkTable.setRID("A000000228");
//		capkTable.setCapki("88");
//		capkTable.setExponent("03");
//		capkTable.setChecksum("36FECD5E5D31CA9D93B91D1B1BB34A150D2834BA");
//		capkTable.setModul("D6589C42073CD94C3C0008098DE209DA46AC0882AB5A0174AACA64A0E8BF2171098FF8A14470B2C0E76B792DBDA2D7AD27416E8D85190C151BF4DC19F51857A85387BA475D66682EAA954139BD1E7E37CF5F35F37DAAEC25B64722E9D68EDC266B4689F05F74D30370CC7C9F2A4B103B9FCDCD524519E9D80AF49E370116CB2287ABF001B5BCC9A34526EBAFD2E88DB752DFE24FE3DF1AFF71733D457B7899E7EB07DC8812DED19CA06D5BE14EC6A9D5");
//		save(capkTable);
    }
}
