package com.smartpos.emvsample.activity;

import android.os.Bundle;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

import com.smartpos.emvsample.R;
import com.smartpos.emvsample.constant.EMVConstant;
import com.smartpos.util.StringUtil;
import com.smartpos.util.WizarTypeUtil;

import static com.cloudpos.jniinterface.EMVJNIInterface.emv_get_config_checksum;
import static com.cloudpos.jniinterface.EMVJNIInterface.emv_get_kernel_checksum;
import static com.cloudpos.jniinterface.EMVJNIInterface.emv_get_version_string;
import static com.cloudpos.jniinterface.EMVJNIInterface.registerFunctionListener;

public class IdleActivity extends FuncActivity implements EMVConstant
{
	private TextView textTitle  = null;
	private Button buttonBack = null;
    private Button   buttonMore = null;
    
	private TextView idleLine1;
	private TextView idleLine2;
	private TextView idleLine3;
	private TextView idleLine4;
	private TextView idleLine5;

	@Override
    public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_idle);
        
        textTitle = (TextView)findViewById(R.id.tAppTitle);
		textTitle.setText("smartpos");
		
	    buttonBack = (Button)findViewById(R.id.btn_back);
        buttonBack.setOnClickListener(new ClickListener());
        
        buttonMore = (Button)findViewById(R.id.btn_more);
        buttonMore.setOnClickListener(new ClickListener());
        
        if(debug) Log.e(APP_TAG, "idleActivity onCreate");
        
        idleLine1 = (TextView)findViewById(R.id.idleLine1);
    	idleLine2 = (TextView)findViewById(R.id.idleLine2);
    	idleLine3 = (TextView)findViewById(R.id.idleLine3);
		idleLine4 = (TextView)findViewById(R.id.idleLine4);
		idleLine5 = (TextView)findViewById(R.id.idleLine5);


		if(appState.wizarType == WizarTypeUtil.WIZARTYPE.WIZARPOS_Q3PDA)
		{
			appState.icInitFlag = true;
		}
    	if(appState.icInitFlag == false)
    	{
    		if(appState.contactService.open())
    		{
    			Log.d(APP_TAG, "ContactICCard open OK");
    			appState.icInitFlag = true;
    		}
    		if(appState.contactlessService.open())
    		{
    			Log.d(APP_TAG, "ContactlessICCard open OK");
    			appState.icInitFlag = true;
    		}
			appState.contactService.close();
			appState.contactlessService.close();
    	}
    }

    @Override
    public void handleMessageSafe(Message msg)
    {
        /*这里是处理信息的方法*/
        switch (msg.what)
        {
        case CARD_INSERT_NOTIFIER:
            Bundle bundle = msg.getData();
            int nEventID = bundle.getInt("nEventID");
            int nSlotIndex = bundle.getInt("nSlotIndex");
            if(debug)Log.d(APP_TAG, "get CONTACT_CARD_EVENT_NOTIFIER,event[" + nEventID + "]slot[" + nSlotIndex + "]" );
            if(   nSlotIndex == 0
                && nEventID == SMART_CARD_EVENT_INSERT_CARD
                )
            {
                cancelMSRThread();
                appState.resetCardError = false;
                appState.trans.setCardEntryMode(INSERT_ENTRY);
                appState.needCard = false;
                sale();
            }
            break;
        case CARD_ERROR_NOTIFIER:
            cancelMSRThread();
            appState.trans.setEmvCardError(true);
            appState.resetCardError = true;
            appState.needCard = true;
            sale();
            break;
        }
    }

    @Override 
    protected void onStart() { 
    	if(debug)Log.e(APP_TAG, "idleActivity onStart"); 
        super.onStart(); 
        appState.initData();

        appState.idleFlag = true;

		registerFunctionListener(this);

		if(appState.emvParamChanged == true){
			appState.setEMVTermInfo();
		}
		idleLine1.setText("GOODS / SERVICE");
		idleLine2.setText("PLEASE INSERT CARD");

		byte[] version = new byte[32];
		byte[] kernelChecksum = new byte[8];
		byte[] configChecksum = new byte[8];

		int len = emv_get_version_string(version, version.length);
		idleLine3.setText(new String(version, 0, len));

		if(emv_get_kernel_checksum(kernelChecksum, kernelChecksum.length) > 0){
			idleLine4.setText("KC: " + StringUtil.toHexString(kernelChecksum, false));
		}
		if(emv_get_config_checksum(configChecksum, configChecksum.length) > 0){
			idleLine5.setText("CC: " + StringUtil.toHexString(configChecksum, false));
		}
		mHandler.setFunActivity(this);

		if(appState.icInitFlag != true){
			appState.idleFlag = false;
			go2Error(R.string.error_init_ic);
			return;
		}
	    if(appState.wizarType != WizarTypeUtil.WIZARTYPE.WIZARPOS_Q3PDA){
		    waitContactCard();
	    }
    }
    
    @Override 
    protected void onResume() { 
    	if(debug)Log.e(APP_TAG, "idleActivity onResume"); 
        super.onResume(); 
    }
    
    @Override 
    protected void onStop() { 
    	if(debug)Log.e(APP_TAG, "idleActivity onStop");
        super.onStop(); 
    }
    
    @Override
    public void onBackPressed(){
		appState.idleFlag = false;
		cancelMSRThread();
		cancelContactCard();
        requestFuncMenu();
    }

	@Override
	protected void onBack()
	{
		onBackPressed();
	}

	@Override
	protected void onCancel()
	{
		onBackPressed();
	}

	@Override
	protected void onEnter()
	{
		onBackPressed();
	}

    public class ClickListener implements View.OnClickListener
    {
		@Override
		public void onClick(View v) 
		{
			switch(v.getId())
			{
			case R.id.btn_back:
			case R.id.btn_more:
				appState.idleFlag = false;
				cancelMSRThread();
				cancelContactCard();
		        requestFuncMenu();
				break;
			}
		}
    }

}
