package com.cloudpos.jniinterface;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;

public class PrinterFloydDitherInterface {
    static {
        String fileName = "jni_cloudpos_printerfloyddither";
        System.loadLibrary(fileName);
    }

    private static native void floydSteinbergNative(Bitmap var1);

    private static native void binaryBlackAndWhiteNative(Bitmap var1);

    public static Bitmap floydSteinbergDithering(Bitmap originalColorBitmap) {
        Bitmap bmpGrayScaled = toGrayscale(originalColorBitmap);
        floydSteinbergNative(bmpGrayScaled);
        return bmpGrayScaled;
    }

    public static Bitmap binaryBlackAndWhite(Bitmap originalColorBitmap) {
        Bitmap bmpGrayScaled = toGrayscale(originalColorBitmap);
        binaryBlackAndWhiteNative(bmpGrayScaled);
        return bmpGrayScaled;
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        Bitmap bmpGrayscale = Bitmap.createBitmap(bmpOriginal.getWidth(), bmpOriginal.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0F);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter) f);
        c.drawBitmap(bmpOriginal, 0.0F, 0.0F, paint);
        return bmpGrayscale;
    }

//    public PrinterFloydDitherInterface() {
//        System.loadLibrary("jni_cloudpos_printerfloyddither");
//    }
}

