package com.cloudpos.jniinterface;

public class ExtBoardInterface {

    static {
        String fileName = "jni_cloudpos_ext_board";
        System.loadLibrary(fileName);
    }

    public static synchronized native int open();

    public static native int read(byte pDataBuffer[], int nExpectedDataLength, int nTimeout_MS);

    public static synchronized native int write(byte pDataBuffer[], int nDataLength);

    public static native int cancelRead();

    public static native boolean isOpened();

    public static native int triggerPulse(int portNum, int voltage, int duration, int interval, int num);

    public static native int triggerRelay(int relayPort, int relayDuration, int relayInterval, int relayCnt);

    public static native int readDIN(int dinPort);

    public static native int setPulseVoltage(int voltage);

    public static native int getBoardVersion();

    public static synchronized native int close();

}
